import { StyleSheet, View } from "react-native";
import React from "react";
import ItemQuantity from "../ItemQuantity/ItemQuantity";
import dpr from "../../../../Utilities/CustomStyleAttribute/dpr";
import AddToCartBtn from "./AddToCartBtn";

const SimpleNvariable = ({
    meta,
    stockManage,
    quantity,
    setQuantity,
    disableBtn,
    cartLoading,
    handleAddToCart,
}) => {
    return (
        <View style={styles.container}>
            <View style={styles.wrap}>
            <ItemQuantity
                meta={meta}
                stockManage={stockManage}
                quantity={quantity}
                setQuantity={setQuantity}
            />
            <AddToCartBtn
                disableBtn={disableBtn}
                cartLoading={cartLoading}
                handleAddToCart={handleAddToCart}
                width={dpr(185)}
            />
            </View>
        </View>
    );
};

export default SimpleNvariable;

const styles = StyleSheet.create({
    container: {
        shadowColor: "#000",
        shadowOffset: {
            width: 0,
            height: -20,
        },
        shadowOpacity: 0.3,
        shadowRadius: 200,
        elevation: 24,
    },
    wrap: {
        backgroundColor: "#FFFFFF",
        flexDirection: "row",
        alignItems: "center",
        justifyContent: "space-between",
        padding: dpr(12),
        width: dpr('wf'),
        zIndex: -999,
    }
});
